/* MoBaServo1xx - Software Version 1
 *	Version 0.1
 *	Bernhard Mayer, 17. Aug. 2009, bernhard-mayer@gmx.net
 *	http://www.blue-parrot.de
 *	fr ATtiny 13
 * FUSEBITS: lfuse=0x6A; hfuse=0xFF; (Default settings)
 * Takt: 1,2 MHz
 * wenn JP1 benutzt werden soll, dann muss die RSTDISBL-Fuse gesetzt werden -> hfuse=0xFE
 */

#include<avr/io.h>
#include<avr/interrupt.h>
#include<avr/sleep.h>
#include<util/delay.h>

volatile uint8_t timer0flag=0;

void adc_init(void)
{
	uint16_t result;
	ADMUX=0;
	ADCSRA=(1<<ADEN)|(1<<ADPS2);					// teiler auf 16 clock=75 kHz
	
	ADCSRA|=(1<<ADSC);								// probewandlung starten
	while(ADCSRA&(1<<ADSC)) ;
	result=ADCW;									// wert auslesen und verwerfen
}
uint8_t read_adc(uint8_t channel)
{
	uint16_t result=0;
	uint8_t i,res8;
	ADMUX=channel;									// Kanal auswaehlen
	for(i=0;i<4;i++)								// 4 mal auslesen
	{	
		ADCSRA|=(1<<ADSC);							// Wandlung starten
		while(ADCSRA&(1<<ADSC)) ;					// warten bis fertig
		result+=ADCW;
	}
	res8=result/16;									// wert berechnen
	return res8;
}
void timer0_init(void)
{
	TCCR0B=(1<<CS01)|(1<<CS00);					// teiler auf 64, maximaler puls= 13,6 ms
	TIMSK0|=(1<<TOIE0);							// Timer Interrupt einschalten
	TCNT0=0;										// Timer ruecksetzen
}

int main(void)
{
	uint8_t count=0, selab=0, adc_val=0;
	DDRB=0x04;										// alle Pins auf eingang bis auf PB2
	PORTB=0x23;										// pull up bei PB0, PB1 und PB5
	
	set_sleep_mode(SLEEP_MODE_IDLE);				// sleep mode IDLE setzen
	sleep_enable();									// sleep aktivieren
	adc_init();										// adc initialisieren
	timer0_init();									// Timer0 initialisieren
	sei();											// Interrupts einschalten
	
	
	while(1)
	{
		if(timer0flag==1)							// nur auswaehlen wenn timer interrupt
		{
			timer0flag=0;							// flag ruecksetzen
			if(count==0)
			{
				TCNT0=255-(adc_val/4);	// wert anfahren
				PORTB|=(1<<PB2);		// servo pin high
				count++;
			}
			else
			{
				count=0;							// schleifenzaehler ruecksetzen
				TCNT0=0;
				PORTB&=~(1<<PB2);					// servo pin low
				if(selab==0) adc_val=read_adc(2);	// adc wert high auslesen
				else adc_val=read_adc(3);			// adc wert low auslesen
			}
		}	
		if(!(PINB&(1<<PB5)))							// Auswertung von JP1
		{	
			if(!(PINB&(1<<PB0))) selab=0;			// wenn tast 1 low, dann adc high auswaehlen
			else selab=1;							// sonst adc low auswaehlen
		}
		else
		{
			if(!(PINB&(1<<PB0))) selab=0;			// wenn tast 1 low, dann adc high auswaehlen
			if(!(PINB&(1<<PB1))) selab=1;			// wenn tast 2 low, dann adc low auswaehlen
		}
		sleep_cpu();								// Controller schlafen schicken
		
	}
	return 0;
}

ISR(TIM0_OVF_vect)
{
	timer0flag=1;									// flag setzen
}